// Header File
// Created 26/10/2003; 11:17:01
//Collisions

//Angles rels du jeu original:
//-----------------------------
//
//5pi/12->55
//pi/3->44
//pi/4->33
//pi/6->22
//pi/12->11


//Collisions avec l'cran
void CollideWithScreen (void)
{
	for (int i=0; i<nbrBille; i++)
	{		
		//Suivant x
		if ((Bille [i]->xpos)<8) {
			//Position correcte de la Bille
			ChangeBillePos (i,8,Bille [i]->ypos);
			//Changement d'angle
			AngleBille (i, 128-Bille [i]->rad);}
		else if ((Bille [i]->xpos+BILLE_SIZEX2)>GAME_WIDTH2) {
			ChangeBillePos (i,GAME_WIDTH2-BILLE_SIZEX2,Bille [i]->ypos);
			AngleBille (i, 128-Bille [i]->rad);}
		
		//Suivant y
		if ((Bille [i]->ypos)<8) {
			ChangeBillePos (i,Bille [i]->xpos,8);
			AngleBille (i, 256-Bille [i]->rad);}
		/*//Dpassement zone de jeu --
		else if ((Bille [i]->ypos+BILLE_SIZEY2)>GAME_HEIGHT2) {
			ChangeBillePos (i,Bille [i]->xpos,GAME_HEIGHT2-BILLE_SIZEY2);
			AngleBille (i, 256-Bille [i]->rad);}*/
			
		//Affichage ombre
		Bille [i]->flag_shadow=TRUE;
		if (((Bille [i]->ypos+(BILLE_SIZEY+3))>GAME_HEIGHT2) || ((Bille [i]->xpos+(BILLE_SIZEX+3))>GAME_WIDTH2))
			Bille [i]->flag_shadow=FALSE;
	}
}

//Collisions avec les billes
/*void CollideWithBilles (void)
{
	short rad;
	short collide;
	
	for (int i=0;i<nbrBille;i++)
	{
		for (int i2=i+1;i2<nbrBille;i2++)
		{	
			//Test collision
			collide=TestCollideSquare (Bille [i2]->xpos, Bille [i2]->ypos, Bille [i]->xpos, Bille [i]->ypos, BILLE_SIZEX, BILLE_SIZEY, BILLE_SIZEX, BILLE_SIZEY);
			
			//Si collision
			if (collide)
			{
				//Oppos
				rad=Bille [i]->rad;
				AngleBille (i, 128+Bille [i]->rad);
				
				//Ne pas fusionner billes
				do
				{
					MoveBille (i, collide);
				} while ((collide=TestCollideSquare (Bille [i2]->xpos, Bille [i2]->ypos, Bille [i]->xpos, Bille [i]->ypos, BILLE_SIZEX, BILLE_SIZEY, BILLE_SIZEX, BILLE_SIZEY)));
				
				//Change de direction
				rad=GCL_Random (256);
				
				//AEvite les mauvais angles
				if (rad<ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER	) rad=ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER;
				else if (rad>(64-ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER) && rad<=64) rad=64-ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER;
				else if (rad>64 && rad<(64+ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER)) rad=64+ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER;
				else if (rad<=128 && rad>(128-ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER)) rad=128-ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER;
				else if (rad>128 && rad<(128+ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER)) rad=128+ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER;
				else if (rad<=192 && rad>(192-ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER)) rad=192-ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER;
				else if (rad>192 && rad<(192+ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER)) rad=192+ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER;
				else if (rad<=256 && rad>(256-ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER)) rad=256-ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER;
					
				//Change angle bille
				AngleBille (i, rad);
				
				//Variation de vitesse
				ChangeBilleSpeed (i, Bille [i]->speed+GCL_Random (MAX_VARSPEED_COLLIDE_BILLE_WIDTH_MONSTER)+MIN_VARSPEED_COLLIDE_BILLE_WIDTH_MONSTER);
				
				//Change de direction
				rad=GCL_Random (256);
				
				//Evite les mauvais angles
				if (rad<ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER	) rad=ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER;
				else if (rad>(64-ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER) && rad<=64) rad=64-ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER;
				else if (rad>64 && rad<(64+ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER)) rad=64+ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER;
				else if (rad<=128 && rad>(128-ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER)) rad=128-ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER;
				else if (rad>128 && rad<(128+ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER)) rad=128+ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER;
				else if (rad<=192 && rad>(192-ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER)) rad=192-ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER;
				else if (rad>192 && rad<(192+ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER)) rad=192+ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER;
				else if (rad<=256 && rad>(256-ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER)) rad=256-ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER;
				
				//Change angle bille
				AngleBille (i2, rad);
				
				//Variation de vitesse
				ChangeBilleSpeed (i2, Bille [i2]->speed+GCL_Random (MAX_VARSPEED_COLLIDE_BILLE_WIDTH_MONSTER)+MIN_VARSPEED_COLLIDE_BILLE_WIDTH_MONSTER);

				//Collision pour bille
				Bille [i]->collide=TRUE;
				Bille [i2]->collide=TRUE;
			}
		}
	}
}*/

//Collisions avec les bricks
void CollideWithBlock (void)
{
	short block_x0, block_y0;
	short block_x[5], block_y[5];
	short block_n;
	
	short collide;
	short rad;
	
	unsigned char block;
	
	BOOL ReDrawMap=FALSE;
	
	//Parcours Billes
	for (int i=0;i<nbrBille;i++)
	{
		//Si dans zone briques
		if (Bille [i]->ypos<=BLOCKS_ENDZONE)
		{
			block_n=0;
			
			//Brique du milieu
			block_x0=((Bille [i]->xpos+(BILLE_SIZEX/2))-START_X)/BLOCK_SIZEX;
			block_y0=((Bille [i]->ypos+(BILLE_SIZEY/2))-START_Y)/BLOCK_SIZEY;
			
			//Si non dpassement de capacit
			if ((block_x0>=0) && (block_x0<13) && (block_y0>=0) && (block_y0<18))
			{ 
				//Collision centre
				block_x [block_n]=block_x0;
				block_y [block_n++]=block_y0;
			
				//Collision brique x
				if ((block_x0-1)>=0) {
					block_x [block_n]=block_x0-1;
					block_y [block_n++]=block_y0;}
			
				if ((block_x0+1)<13) {
					block_x [block_n]=block_x0+1;
					block_y [block_n++]=block_y0;}
				
				//Collision brique y
				if ((block_y0-1)>=0) {
					block_x [block_n]=block_x0;
					block_y [block_n++]=block_y0-1;}
			
				if ((block_y0+1)<18) {
					block_x [block_n]=block_x0;
					block_y [block_n++]=block_y0+1;}
				
				//Parcours briques collisions
				for (int j=0;j<block_n;j++)
				{
					block=LevelMap [block_y [j]][block_x [j]];
				
					if (block&0x0F)
					{
						//Coordonnes du bloc en cours
						block_x0=(block_x [j]*BLOCK_SIZEX)+START_X;
						block_y0=(block_y [j]*BLOCK_SIZEY)+START_Y;
						
						//Test de collision
						collide=TestCollideSquare (block_x0, block_y0, Bille [i]->xpos, Bille [i]->ypos, BLOCK_SIZEX, BLOCK_SIZEY, BILLE_SIZEX, BILLE_SIZEY);
						
						if (collide)
						{
							//************
							//Bille normal
							//************
							if (Bille [i]->type==BILLE_NOFIRE)
							{
								//Sauvegarde angle
								rad=Bille [i]->rad;
					
								//Angle oppos
								AngleBille (i,128+rad);
					
								//Tant que dans la brique
								do {
									MoveBille (i, collide);
								} while ((collide=TestCollideSquare (block_x0, block_y0, Bille [i]->xpos, Bille [i]->ypos, BLOCK_SIZEX, BLOCK_SIZEY, BILLE_SIZEX, BILLE_SIZEY)));							
					
								//Changement angle
								//if (!block_dir [j])
								//{
									//Suivant x
									if (GetDirCollideSquare (block_x0, block_y0, Bille [i]->xpos, Bille [i]->ypos, BLOCK_SIZEX, BLOCK_SIZEY, BILLE_SIZEX, BILLE_SIZEY)==1)
									//if (GetDirCollide_0 (Bille [i]->xpos, Bille [i]->ypos, block_x0, block_y0, BILLE_SIZEX, BILLE_SIZEY, BLOCK_SIZEX+1, BLOCK_SIZEY)==1)
										AngleBille (i,128-rad);
									//suivant y
									else
										AngleBille (i,256-rad);
								//}
								//else if ((block_dir [j]<=2)) AngleBille (i,128-rad);
								//else AngleBille (i,256-rad);
							
								//Blocks en acier (animations ou double destructions)
								//Acier gris
								if ((block&0x8F)==0x06) {CREATE_ANIM_BLOCK (block_x [j],block_y [j],0x06); LevelMap [block_y[j]][block_x[j]] |= 0x80;}
								//Spcial en 2
								else if ((block&0x8F)==0x0B) {CREATE_ANIM_BLOCK (block_x [j],block_y [j],0x0B); LevelMap [block_y[j]][block_x[j]] |= 0x80;}
								//Acier jaune incassable
								else if ((block&0x8F)==0x08) CREATE_ANIM_BLOCK (block_x [j],block_y [j],0x08);
					
								//Sinon dtruire
								else
								{
									//Gestion graphique
									if (((block&0x0F)!=0x0B) && ((block&0x0F)!=0x08)) COUNTER_BRICKS--;
									ReDrawMap=TRUE;
									LevelMap [block_y[j]][block_x[j]]=0;
								
									DrawMapBackground (block_x [j],block_y [j]);
								
									//Gestion Bonus
									if (block&0x10) SetBonus (block_x0+2,block_y0+BLOCK_SIZEY);
								}
								
								//Collision pour bille
								Bille [i]->collide=TRUE;
							}
							//************
							//Bille de feu
							//************
							else
							{
								//Soustrait compteur de briques
								if (((block&0x0F)!=0x0B) && ((block&0x0F)!=0x08)) COUNTER_BRICKS--;
								ReDrawMap=TRUE;
								LevelMap [block_y[j]][block_x[j]]=0;
								
								DrawMapBackground (block_x [j],block_y [j]);
								
								//Gestion Bonus
								if (block&0x10) SetBonus (block_x0+2,block_y0+BLOCK_SIZEY);
							}
							
							break;
						}
					}
				}
			}
		}
	}
	
	//Si redessiner niveau
	if (ReDrawMap) MAP_ShowSpecialBricks_MOVE ();
}

//Collisions avec bricks spciales
void CollideWithBlock_Special (void)
{
	unsigned char block=0;
	BOOL ReDrawMap=FALSE;
	BOOL CollideBrick=FALSE;
	
	short rad;
	short collide;
	
	//Parcours billes
	for (int i=0; i<nbrBille; i++)
	{
		//Si dans zone de briques
		if (Bille [i]->ypos<=BLOCKS_ENDZONE)
		{
			for (unsigned short j=0;j<bricks_special_move_n;j++)
			{
				if (!MAP_bricks_special_move_destroy [j])
				{
					CollideBrick=FALSE;
				
					//Test de collision
					collide=TestCollideSquare (MAP_bricks_special_move_x [j], MAP_bricks_special_move_y [j], Bille [i]->xpos, Bille [i]->ypos, BLOCK_SIZEX, BLOCK_SIZEY, BILLE_SIZEX, BILLE_SIZEY);
									
					//Si collision
					if (collide)
					{
						//Collision!
						CollideBrick=TRUE;
						
						//************					
						//Bille normal
						//************
						if (Bille [i]->type==BILLE_NOFIRE)
						{
							//Angle oppos
							rad=Bille [i]->rad;
							AngleBille (i, 128+Bille [i]->rad);
						
							//Tant que dans la brique
							do {
								MoveBille (i, collide);
							} while ((collide=TestCollideSquare (MAP_bricks_special_move_x [j], MAP_bricks_special_move_y [j], Bille [i]->xpos, Bille [i]->ypos, BLOCK_SIZEX, BLOCK_SIZEY, BILLE_SIZEX, BILLE_SIZEY)));								
						
							//Test suivant x ou y
							if ((Bille [i]->xpos>(MAP_bricks_special_move_x [j]+BLOCK_SIZE2_X)) || ((Bille [i]->xpos+BILLE_SIZEX2)<MAP_bricks_special_move_x [j]))
								AngleBille (i, 128-rad);
							else
								AngleBille (i, 256-rad);
						}
					}
				
					//Si collision
					if (CollideBrick && (Bille [i]->type==BILLE_NOFIRE))
					{
						block=MAP_bricks_special_move_sprite [j];
					
						//Blocks en acier (animations ou double destructions)
						//Acier gris
						if ((block&0x8F)==0x06) {MAP_bricks_special_move_sprite [j] |= 0x80; MAP_bricks_special_move_dep [j]=TRUE;}
						//Spcial en 2
						else if ((block&0x8F)==0x0B) {MAP_bricks_special_move_sprite [j] |= 0x80; MAP_bricks_special_move_dep [j]=TRUE;}
						//Si diffrent Acier jaune incassable alors casser
						else if ((block&0x8F)==0x08) MAP_bricks_special_move_sprite [j] |= 0x80;
						else if ((block&0x8F)==0x88) MAP_bricks_special_move_dep [j]=TRUE;
						else
						{
							//Gestion graphique
							if (((block&0x0F)!=0x0B) && ((block&0x0F)!=0x08)) COUNTER_BRICKS--;
							MAP_bricks_special_move_destroy [j]=TRUE;
							ReDrawMap=TRUE;
							
							//Gestion Bonus
							if (block&0x10) SetBonus (MAP_bricks_special_move_x [j]+2,MAP_bricks_special_move_y [j]+BLOCK_SIZEY);
						}
						
						//Collision pour bille
						Bille [i]->collide=TRUE;
					}
					//************
					//Bille de feu
					//************
					else if (CollideBrick && (Bille [i]->type==BILLE_FIRE))
					{
						block=MAP_bricks_special_move_sprite [j];
						
						//Gestion graphique
						if (((block&0x0F)!=0x0B) && ((block&0x0F)!=0x08)) COUNTER_BRICKS--;
						MAP_bricks_special_move_destroy [j]=TRUE;
						ReDrawMap=TRUE;
							
						//Gestion Bonus
						if (block&0x10) SetBonus (MAP_bricks_special_move_x [j]+2,MAP_bricks_special_move_y [j]+BLOCK_SIZEY);
					}
				}
			}
		}
	}
	
	//Si redessiner niveau
	if (ReDrawMap) MAP_ReDrawMap ();
}

//Collision rackets avec l'cran
void Rackets_CollideWithScreen (void)
{
	//Parcours rackets
	for (int i=0;i<nbrRacket;i++)
	{
		//Sans double racket
		if ((!Racket [i]->isDoubleRacket) && (!Racket [i]->double_racket))
		{
			//Collision sprite
			if (Racket [i]->xpos<START_X) Racket [i]->xpos=START_X;
			else if ((Racket [i]->xpos+Racket [i]->size_x2)>GAME_WIDTH2) Racket [i]->xpos=GAME_WIDTH2-Racket [i]->size_x2;
		}
		//Avec Double racket
		else if (Racket [i]->double_racket)
		{
			//Infrieur
			if (Racket [i]->xpos<START_X)
			{
				Racket [i]->xpos=START_X;
				Racket [Racket [i]->double_racket_n]->xpos=START_X+36;
			}
			//Suprieur
			else if ((Racket [i]->xpos+36+28)>GAME_WIDTH2)
			{
				Racket [i]->xpos=GAME_WIDTH2-28-36;
				Racket [Racket [i]->double_racket_n]->xpos=GAME_WIDTH2-28;
			}
		}
		
		//Collision ombre
		Racket [i]->flag_shadow=TRUE;
		//Suivant y
		if (((Racket [i]->ypos+(Racket [i]->size_y+(Racket [i]->size_y/3)))>GAME_HEIGHT2)
		//Suivant x	
		|| ((Racket [i]->xpos+(Racket [i]->size_x+(Racket [i]->size_x/4)))>GAME_WIDTH2))
			Racket [i]->flag_shadow=FALSE;	
	}
}

//Collision Bille avec Rackets
void Rackets_CollideWithBilles (void)
{
	short rad;
	short add_dir;
	short collide0=0,collide1=0;
	//short distx;
	BOOL flag_sprite8;
	
	//Parcours Billes
	for (int i=0;i<nbrBille;i++)
	{
		//Parcours Rackets
		for (int j=0;j<nbrRacket;j++)
		{
			//Copie de masques
			CopySprite8_32 (SPRITE_BILLE,BufferSprite32_0,BILLE_SIZEY,Racket [j]->size_y);
			CopySprite32_32 (SPRITE_RACKETS [Racket [j]->sprite][Racket [j]->sprite_anim],BufferSprite32_1,Racket [j]->size_y,Racket [j]->size_y);
			
			flag_sprite8=FALSE;
			
			//Fin de la racket 8x9 pixels
			if ((Racket [j]->size==2) || (Racket [j]->size==5))
			{
				CopySprite8_8 (SPRITE_BILLE,BufferSprite8_0,BILLE_SIZEY,Racket [j]->size_y);
				CopySprite8_8 (SPRITE_RACKETS [Racket [j]->sprite][Racket [j]->sprite_anim]+Rackets_size0,BufferSprite8_1,Racket [j]->size_y,Racket [j]->size_y);
				flag_sprite8=TRUE;
			}
			
			//Collision sur 32 pixels
			collide0=CollideSprite32 (Bille [i]->xpos, Bille [i]->ypos, Racket [j]->xpos, Racket [j]->ypos, Racket [j]->size_y, BufferSprite32_0, BufferSprite32_1);
			
			//Collision sur 8 pixels
			collide1=0;
			if (flag_sprite8)
				collide1=CollideSprite8 (Bille [i]->xpos, Bille [i]->ypos, Racket [j]->xpos+32, Racket [j]->ypos, Racket [j]->size_y, BufferSprite8_0, BufferSprite8_1);
			
			//Racket non touch
			Racket [j]->touch=FALSE;
							
			//Collision
			if (collide0 || collide1)
			{					
				//Angle oppos
				AngleBille (i, 128+Bille [i]->rad);
				
				//Eviter fusion
				while (collide0 || collide1)
				{
					MoveBille (i,1);
					
					//Collision sur 32 pixels
					collide0=CollideSprite32 (Bille [i]->xpos, Bille [i]->ypos, Racket [j]->xpos, Racket [j]->ypos, Racket [j]->size_y, BufferSprite32_0, BufferSprite32_1);
			
					//Collision sur 8 pixels
					collide1=0;
					if (flag_sprite8)
						collide1=CollideSprite8 (Bille [i]->xpos, Bille [i]->ypos, Racket [j]->xpos+32, Racket [j]->ypos, Racket [j]->size_y, BufferSprite8_0, BufferSprite8_1);
				}
				
				//--------------------------------								
				/*//Distance entre le centre de la bille est la raquette
				distx=(Racket [j]->xpos+(Racket [j]->size_x2/2))-(Bille [i]->xpos+(BILLE_SIZEX2/2));
				
				//Application de pi/2 ou -pi/2
				if (Bille [i]->ydir<0) rad=64;
				else rad=192;
				
				//Calcul de nouvelle direction 54=distance entre 118-64 et 64-10 soit distance entre pi/2-pi/12 et pi/2-11pi/12
				//add_dir=(distx*54)/Racket [j]->size_x;
				add_dir=(78/Racket [j]->size_x)*distx;
				
				//Gestion 40 cart max
				if (add_dir>38) add_dir=38;
				else if (add_dir<-38) add_dir=-38;
				
				//Gestion 12 cart min
				if ((add_dir>=0) && (add_dir<12)) add_dir=12;
				else if ((add_dir<0) && (add_dir>-12)) add_dir=-12;
				
				//Inverse si direction de collision est vers le bas
				if (rad==192) add_dir*=-1;
								
				//Angle bille
				AngleBille (i, rad+add_dir);*/
				//----------------------------------
				
				//Application de pi/2 ou -pi/2
				if (Bille [i]->ydir==-1) {rad=64; add_dir=1;}
				else {rad=192; add_dir=-1;}
				
				if (Bille [i]->xpos<=Racket [j]->xpos+7) rad+=28*add_dir;
				else if (Bille [i]->xpos>=(Racket [j]->xpos+Racket [j]->size_x2)-7) rad-=28*add_dir;
				else if (Bille [i]->xpos<=Racket [j]->xpos+(Racket [j]->size_x/2)-(Racket [j]->size_x/8)) rad+=18*add_dir;
				else if (Bille [i]->xpos>=Racket [j]->xpos+(Racket [j]->size_x/2)+(Racket [j]->size_x/8)) rad-=18*add_dir;
				else if (Bille [i]->xpos<=Racket [j]->xpos+(Racket [j]->size_x/2)) rad+=11*add_dir;
				else rad-=11*add_dir;
				
				//Inverse si direction de collision est vers le bas
				if (Bille [i]->ydir==1) rad+=256;
				
				//Angle bille
				AngleBille (i, rad);
				
				//Variation de vitesse en fonction de la raquette
				ChangeBilleSpeed (i, Bille [i]->speed+(abs(Racket [j]->xpos2-Racket [j]->xpos)/RACKET_VARSPEED));
				
				//Collision pour bille
				Bille [i]->collide=TRUE;
				
				//Raquette touche
				Racket [j]->touch=TRUE;
				
				//-------------------
				//Gestion Bonus Colle
				//-------------------
				if (Racket [j]->colle && ((j!=HUMAIN0) || (j==HUMAIN0 && StartGameForHumain0)))
					Bonus_RacketColle (j,i);
			}
		}
	}
}

//Collision Missiles avec blocks
void Missiles_CollideWithBlock (void)
{
	unsigned char block_x[2];
	unsigned char block_y;
	unsigned char block_n;
	unsigned char block;
	
	short xblock, yblock;
	short missile_anim_y=0;
	
	BOOL ReDrawMap=FALSE;
	BOOL delete_missile=FALSE;
	
	//Parcours Missiles
	for (int i=0;i<nbrMissile;i++)
	{
		//Si dans zone briques
		if (MISSILE_ypos [i]<=BLOCKS_ENDZONE)
		{
			delete_missile=FALSE;
			block_n=1;
			
			//Collision de dbut x+0
			block_x[0]=(MISSILE_xpos [i]+1-START_X)/BLOCK_SIZEX;
			//Collision de fin x+2
			block_x[1]=((MISSILE_xpos [i]+(MISSILE_RIGHT+1))-START_X)/BLOCK_SIZEX;
			
			//Brique suivant y
			block_y=(MISSILE_ypos [i]-START_Y)/BLOCK_SIZEY;
			
			//Si 2 briques en mme temps
			if (block_x [0]!=block_x [1]) block_n=2;
			
			//Parcours blocks
			for (int j=0;j<block_n;j++)
			{
				//Si block existe
				block=LevelMap [block_y][block_x [j]];
				if (block&0x0F)
				{
					//Coordonnes du block
					xblock=(block_x[j]*BLOCK_SIZEX)+START_X;
					yblock=(block_y*BLOCK_SIZEY)+START_Y;
					
					//Efface Missile
					delete_missile=TRUE;
					missile_anim_y=yblock+BLOCK_SIZEY;
					
					//Blocks en acier (animations ou double destructions)
					//Acier gris
					if ((block&0x8F)==0x06) {CREATE_ANIM_BLOCK (block_x [j],block_y,0x06); LevelMap [block_y][block_x[j]] |= 0x80;}
					//Spcial en 2
					else if ((block&0x8F)==0x0B) {CREATE_ANIM_BLOCK (block_x [j],block_y,0x0B); LevelMap [block_y][block_x[j]] |= 0x80;}
					//Acier jaune incassable
					else if ((block&0x8F)==0x08) CREATE_ANIM_BLOCK (block_x [j],block_y,0x08);
					
					//Sinon dtruire
					else
					{
						//Gestion graphique
						if (((block&0x0F)!=0x0B) && ((block&0x0F)!=0x08)) COUNTER_BRICKS--;
						ReDrawMap=TRUE;
						LevelMap [block_y][block_x[j]]=0;
						
						DrawMapBackground (block_x [j],block_y);
							
						//Gestion Bonus
						if (block&0x10) SetBonus (xblock+2,yblock+BLOCK_SIZEY);
					}
				}
			}
			
			//Si effacer Missile
			if (delete_missile)
			{
				//Arrte interruption
				StartIntMissiles=FALSE;
				
				//Crer animation
				CREATE_ANIM_MISSILE (MISSILE_xpos [i],missile_anim_y);
				
				//Efface Missile
				Racket [MISSILE_racket [i]]->nbrMissile--;
				Racket [MISSILE_racket [i]]->COUNTER_MISSILE_TIME_SHOOT=MISSILES_TIME_SHOOT;
				DeleteMissile (i--);
				
				//Active interruption
				StartIntMissiles=TRUE;
			}
		}
	}
	
	//Si redessiner niveau
	if (ReDrawMap) MAP_ShowSpecialBricks_MOVE ();
}

//Collision Missiles avec blocks spciaux
void Missiles_CollideWithBlock_Special (void)
{
	short collide0,collide1;
	unsigned char block;
	short missile_anim_y=0;
	BOOL delete_missile=FALSE;
	
	BOOL ReDrawMap=FALSE;
	
	//Parcours Missiles
	for (int i=0; i<nbrMissile; i++)
	{
		//Si dans zone de briques
		if (MISSILE_ypos [i]<=BLOCKS_ENDZONE)
		{
			delete_missile=FALSE;
			
			for (unsigned short j=0;j<bricks_special_move_n;j++)
			{
				//Si non dtruite
				if (!MAP_bricks_special_move_destroy [j])
				{
					//Collision Missile0
					collide0=TestCollideSquare (MAP_bricks_special_move_x [j], MAP_bricks_special_move_y [j], MISSILE_xpos[i], MISSILE_ypos[i], BLOCK_SIZEX, BLOCK_SIZEY, MISSILE_SIZEX, MISSILE_SIZEY);
					//Collision Missile1
					collide1=TestCollideSquare (MAP_bricks_special_move_x [j], MAP_bricks_special_move_y [j], MISSILE_xpos[i]+MISSILE_RIGHT, MISSILE_ypos[i], BLOCK_SIZEX, BLOCK_SIZEY, MISSILE_SIZEX, MISSILE_SIZEY);
					
					//Si collision
					if (collide0 || collide1)
					{
						//Efface missile
						delete_missile=TRUE;
						missile_anim_y=MAP_bricks_special_move_y [j]+BLOCK_SIZEY;
						
						block=MAP_bricks_special_move_sprite [j];
					
						//Blocks en acier (animations ou double destructions)
						//Acier gris
						if ((block&0x8F)==0x06) {MAP_bricks_special_move_sprite [j] |= 0x80; MAP_bricks_special_move_dep [j]=TRUE;}
						//Spcial en 2
						else if ((block&0x8F)==0x0B) {MAP_bricks_special_move_sprite [j] |= 0x80; MAP_bricks_special_move_dep [j]=TRUE;}
						//Si diffrent Acier jaune incassable alors casser
						else if ((block&0x8F)==0x08) MAP_bricks_special_move_sprite [j] |= 0x80;
						else if ((block&0x8F)==0x88) MAP_bricks_special_move_dep [j]=TRUE;
						else
						{
							//Gestion graphique
							if (((block&0x0F)!=0x0B) && ((block&0x0F)!=0x08)) COUNTER_BRICKS--;
							MAP_bricks_special_move_destroy [j]=TRUE;
							ReDrawMap=TRUE;
							
							//Gestion Bonus
							if (block&0x10) SetBonus (MAP_bricks_special_move_x [j]+2,MAP_bricks_special_move_y [j]+BLOCK_SIZEY);
						}
					}
				}
			}
			
			//Si effacer Missile
			if (delete_missile)
			{
				//Arrte interruption
				StartIntMissiles=FALSE;
				
				//Crer animation
				CREATE_ANIM_MISSILE (MISSILE_xpos [i],missile_anim_y);
				
				//Efface Missile
				Racket [MISSILE_racket [i]]->nbrMissile--;
				Racket [MISSILE_racket [i]]->COUNTER_MISSILE_TIME_SHOOT=MISSILES_TIME_SHOOT;
				DeleteMissile (i--);
				
				//Active interruption
				StartIntMissiles=TRUE;
			}
		}
	}
	
	//Si redessiner niveau
	if (ReDrawMap) MAP_ReDrawMap ();
}

//Collision racket Ghost avec Billes
void Rackets_CollideBillesWithGhost (void)
{
	short collide;
	short x;
	short rad;
	
	//Parcours rackets
	for (int i=0;i<nbrRacket;i++)
	{
		//Si Bonus Ghost
		if (Racket [i]->ghost && (Racket [i]->ghost_xpos>15))
		{
			//Parcours Billes
			for (int j=0;j<nbrBille;j++)
			{	
				//Droite
				if (Racket [i]->ghost_dir==1)
					x=Racket [i]->xpos+29;
				//Gauche
				else
					x=Racket [i]->xpos+15-Racket [i]->ghost_xpos;
				
				collide=TestCollideSquare (Bille [j]->xpos, Bille [j]->ypos,x,Racket [i]->ypos,BILLE_SIZEX,BILLE_SIZEY,Racket [i]->ghost_xpos-15,9);
				//Si Collision
				if (collide)
				{
					//Sauvegarde angle
					rad=Bille [j]->rad;
					
					//Angle oppos
					AngleBille (j, 128+rad);
					
					//Dfusion
					MoveBille (j,collide);
					
					//Modification angle
					AngleBille (j, 256-rad);
					
					//Collision pour bille
					Bille [j]->collide=TRUE;
				}
			}
		}
	}
}

//Bille sort de la zone de jeu
void ExitBille (void)
{
	//Parcours billes
	for (int i=0;i<nbrBille;i++)
	{
		//La Bille est sortie
		if ((Bille [i]->ypos+BILLE_SIZEX2)>GAME_HEIGHT2)
		{
			//Effacer Bille
			DeleteBille (i--);
		}
	}
}